/* UMark
 * Copyright (C)2003-2005 Jeffrey Bakker

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   ___________________________________ .. .
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>

#include "interface.h"
#include "support.h"


/*** error messages **********************************************************/
void
message_dialog(GtkWidget* MainWnd, gchar* info)
{
	GtkWidget *Dlg, *Lbl;
	Dlg = gtk_dialog_new_with_buttons(	"UMark",
						GTK_WINDOW(MainWnd),
						GTK_DIALOG_DESTROY_WITH_PARENT,
						GTK_STOCK_OK,
						GTK_RESPONSE_OK,
						NULL);

/*	g_object_set(GTK_WIDGET(Dlg), "action-area-border", 10, NULL);
*/	Lbl = gtk_label_new(info);

	g_signal_connect_swapped(Dlg,
				"response",
				G_CALLBACK(gtk_widget_destroy),
				Dlg);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dlg)->vbox), Lbl);
	gtk_widget_show_all(Dlg);
}

/*** construct GtkTreeViews **************************************************/
static GtkTreeModel *
create_fill_batchlist(void)
{
	GtkListStore	*store;
	GtkTreeIter	iter;

	store = gtk_list_store_new(1, G_TYPE_STRING);

	return GTK_TREE_MODEL(store);
}

/* static GtkWidget* */
void
create_model_batchlist(GtkWidget *TVBL)
{
	GtkTreeViewColumn	*col;
	GtkCellRenderer		*renderer;
	GtkTreeModel		*model;
	GtkWidget		*view;

	view = TVBL;
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
							-1,
							"Map List",
							renderer,
							"text", 0,
							NULL);

	model = create_fill_batchlist();

	gtk_tree_view_set_model(GTK_TREE_VIEW(view), model);
	g_object_unref(model);

/*	return view; */
}

/*** main ********************************************************************/
int
main (int argc, char *argv[])
{
/* TODO: use utxinfo.pl to grab installed versions of UT200x and fill 
	 the UT200x version combobox accordingly */

	GtkWidget	*UMarkDlg;
	GtkWidget	*PresetsDlg;
	gchar		*umarkrc;
	FILE		*RCFILE;

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

	if(argc > 1)
	{

	}
	else
	{

	}

	UMarkDlg = create_UMarkDlg();
	gtk_widget_show(UMarkDlg);

	umarkrc = g_strdup_printf("%s/.umarkrc", getenv("HOME"));
	if((RCFILE = fopen(umarkrc, "r")) == NULL)
	{
		message_dialog(UMarkDlg, "Could not find the UMark config file. Please run the UMark/install_umark_data.sh script.");
	}
	else
	{
		GtkTreeModel	*cbTmod;
		GtkComboBox	*cbVers;
		gchar		*line;
		gchar		buffer;
		gint		lnum;

		cbVers = GTK_COMBO_BOX(lookup_widget( GTK_WIDGET(UMarkDlg), "CmbVersion"));
		cbTmod = GTK_TREE_MODEL(gtk_combo_box_get_model(cbVers));

		gtk_list_store_clear(GTK_LIST_STORE(cbTmod));

		line = "";
		lnum = 1;

		while((buffer = getc(RCFILE)) != EOF)
		{
			/* TODO: pass info in gchar* line to on_version_changed in callbacks.c */
			if(buffer == '\n')
			{
				if(lnum == 1 && strcmp(line, "n/a|n/a") != 0)
				{
					gtk_combo_box_append_text(GTK_COMBO_BOX(cbVers), "ut2003");
				}
				else
				if(lnum == 2 && strcmp(line, "n/a|n/a") != 0)
				{
					gtk_combo_box_append_text(GTK_COMBO_BOX(cbVers), "ut2004");
				}
				else
				if(lnum == 3 && strcmp(line, "n/a|n/a") != 0)
				{
					gtk_combo_box_append_text(GTK_COMBO_BOX(cbVers), "ut2003_demo");
				}

				line = "";
				lnum++;
			}
			else
			{
				line = g_strdup_printf("%s%c", line, buffer);
			}
		}
		fclose(RCFILE);
	}
	create_model_batchlist(lookup_widget( GTK_WIDGET(UMarkDlg), "tvBatchList") );

	gtk_main();

	return 0;
}
