#!/usr/bin/perl -w

 # UMark
 # Copyright (C)2003-2004 Jeffrey Bakker

 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.

 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.

 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 # This script is used to gather the information, in which reveals
 # the complete path to execute UT200x. UMark will use this information
 # to determine which games are installed, and how to launch it.


use strict;

my $line;

my $ut2003;
my $ut2004;
my $ut2k3d;
my $ut2k4d;

my $build3r = "n/a";
my $build3d = "n/a";
my $build4r = "n/a";
my $build4d = "n/a";

if(system("which ut2003 1>/dev/null") != 0)
{
	$ut2003 = "n/a";
}
else
{
	($ut2003 = `ls -l \`which ut2003\``) =~ s/.*->\s{0,}//g;
	chomp $ut2003;
	$ut2003 =~ s!/ut2003$!!;

	open(LOG3, "<$ENV{'HOME'}/.ut2003/System/UT2003.log");
	my @log3 = <LOG3>;
	close(LOG3);

	foreach $line (@log3)
	{
		if($line =~ m/Init: Version: /)
		{
			$build3r = $line;
			print $line;
		}
	}
	if($build3r ne "n/a")
	{
		$build3r =~ s/Init: Version: ([0-9][0-9][0-9][0-9]) .*/$1/;
		chomp $build3r;
	}
	else
	{
		print "UT2003 Retail is installed, but you need to run it as this current user at least once first to create a log file. You need to re-run this script in order to benchmark this game with UMark.\n";
		$ut2003 = "n/a";
	}

#	($ut2003 = $log3[7]) =~ s!Init: Base directory: (.*)/System!$1!;
#	chomp $ut2003;
#	$ut2003 =~ s!/$!!;
}

if(system("which ut2004 1>/dev/null") != 0)
{
	$ut2004 = "n/a";
}
else
{
	($ut2004 = `ls -l \`which ut2004\``) =~ s/.*->\s{0,}//g;
	chomp $ut2004;
	$ut2004 =~ s!/ut2004$!!;
	$ut2004 =~ s!/$!!;

	open(LOG4, "<$ENV{'HOME'}/.ut2004/System/UT2004.log");
	my @log4 = <LOG4>;
	close(LOG4);

	foreach $line (@log4)
	{
		if($line =~ m/Init: Version: /)
		{
			$build4r = $line;
			print $line;
		}
	}
	if($build4r ne "n/a")
	{
		$build4r =~ s/Init: Version: ([0-9][0-9][0-9][0-9]) .*/$1/;
		chomp $build4r;
	}
	else
	{
		print "UT2004 Retail is installed, but you need to run it as this current user at least once first to create a log file. You also need to re-run this script in order to benchmark this game with UMark.\n";
		$ut2004 = "n/a";
	}

#	($ut2004 = $log4[7]) =~ s!Init: Base directory: (.*)/System!$1!;
#	chomp $ut2004;
#	$ut2004 =~ s!/$!!;
}

if(system("which ut2003_demo 1>/dev/null") != 0)
{
	$ut2k3d = "n/a";
}
else
{
	($ut2k3d = `ls -l \`which ut2003_demo\``) =~ s/.*->\s{0,}//g;
	chomp $ut2k3d;
	$ut2k3d =~ s!/ut2003_demo$!!;

	open(LOG3, "<$ENV{'HOME'}/.ut2003/System/UT2003.log");
	my @log3 = <LOG3>;
	close(LOG3);

	foreach $line (@log3)
	{
		if($line =~ m/Init: Version: /)
		{
			$build3d = $line;
			print $line;
		}
	}
	if($build3d ne "n/a")
	{
		$build3d =~ s/Init: Version: ([0-9][0-9][0-9][0-9]) .*/$1/;
		chomp $build3d;
	}
	else
	{
		print "UT2003 Demo is installed, but you need to run it as this current user at least once first to create a log file. You also need to re-run this script in order to benchmark this game with UMark.\n";
		$ut2k3d = "n/a";
	}

#	($ut2k3d = $log3[7]) =~ s!Init: Base directory: (.*)/System!$1!;
#	chomp $ut2k3d;
#	$ut2k3d =~ s!/$!!;
}

chomp $ut2003;
chomp $ut2004;
chomp $ut2k3d;

print "UT2003 Retail Version $build3r installed in $ut2003\n";
print "UT2004 Retail Version $build4r installed in $ut2004\n";
print "UT2003 Demo Version $build3d installed in $ut2k3d\n";

open(UMARKRC, ">$ENV{'HOME'}/.umarkrc");
select(UMARKRC);

print "$build3r|$ut2003\n";
print "$build4r|$ut2004\n";
print "$build3d|$ut2k3d\n";

close(UMARKRC);
